#include <stdio.h>
#include <cdefBF535.h>
#include <signal.h>

void spi_isr(int i);


short int SPI_RD_VALUE[100];
short int SPI_RD_VALUE_TEMP;
int dma_count;

void main(void)
{
	
	
	//Clear the SPI0 registers
	*pSPI0_FLG = 0;
	*pSPI0_BAUD = 0;
	*pSPI0_CTL = 0;
	*pSPI0_CONFIG = 0;
	//Autobuffer
	*pSPI0_CONFIG = 0x10;//First set the auto buffer mode for DMA
	*pSPI0_CONFIG |=0x06;//Set the other DMA config parameters
	*pSPI0_START_ADDR_HI = 0xff80;
	*pSPI0_START_ADDR_LO = 0x0008;
	*pSPI0_COUNT = 2;

	
	
	//set up interrupt mask for SPI0 interrupt.spi_isr is the interrupt handler
	interrupt(SIGIVG9, spi_isr);
	
	*pSIC_IMASK = SIC_MASK8;//SIC_MASK_ALL;
	
	*pSPI0_FLG = FLS1;//PF2 becomes CS# for AD7276
	//*pSPI0_CTL = TIMOD2  | SIZE | CPOL | MSTR | SPE | SZ;
	*pSPI0_CTL = TIMOD2  | SIZE | CPOL | MSTR | SZ;
	//For TIMOD1 condition, modified the defBF535.h file
	*pSPI0_BAUD = 6;//This value will decide the serial bit clock for AD7276 
	
	//======================================
	*pSPI0_CONFIG |= 0x01;//Enable DMA here
	*pSPI0_CTL |= SPE;//Enable SPI here
	
	while(1)
	{
		//wait for SPI receive DMA interrupt
	}
	
	
	
}

void spi_isr(int i)
{
	*pSPI0_CTL = 0x00;//Disable SPI here
	*pSPI0_CONFIG = 0x00;//Disable DMA here
	*pSPI0_CTL = TIMOD1  | CPOL | MSTR | SZ | SPE;//configure for 8 bit tranfer
	*pSPI0_TDBR = 0xAA;//8-bit dummy write to power down the ADC
	
	//post process the data to shift two bits right
	for (dma_count=0; dma_count<=4; dma_count++)
	{
		SPI_RD_VALUE[dma_count] = SPI_RD_VALUE[dma_count] >> 2;
	}
	
	*pSPI0_CTL = 0x00;//Disable SPI here
}
